import { getServerSession } from 'next-auth';
import { authOptions } from '@/lib/auth';
import { redirect } from 'next/navigation';
import { prisma } from '@/lib/prisma';
import { getUsageStats } from '@/lib/usage';
import UsageCard from '@/components/usage-card';

export default async function DashboardPage() {
  const session = await getServerSession(authOptions);

  if (!session) {
    redirect('/login');
  }

  const restaurant = await prisma.restaurant.findFirst({
    where: { ownerId: session.user.id },
  });

  if (!restaurant) {
    redirect('/login');
  }

  const stats = await getUsageStats(restaurant.id);

  return (
    <div className="container mx-auto px-4 py-8">
      <h1 className="text-3xl font-bold mb-8">Dashboard</h1>

      <div className="grid gap-6 md:grid-cols-2">
        <UsageCard
          stats={stats}
          onUpgrade={() => {}}
        />

        <div className="grid gap-4">
          <div className="bg-white rounded-lg shadow p-6">
            <h3 className="text-sm font-medium text-gray-500">Total Produse</h3>
            <p className="text-3xl font-bold mt-2">{stats.products.used}</p>
          </div>

          <div className="bg-white rounded-lg shadow p-6">
            <h3 className="text-sm font-medium text-gray-500">Total Categorii</h3>
            <p className="text-3xl font-bold mt-2">{stats.categories.used}</p>
          </div>

          <div className="bg-white rounded-lg shadow p-6">
            <h3 className="text-sm font-medium text-gray-500">Meniul tău</h3>
            
              href={`/r/${restaurant.slug}`}
              target="_blank"
              rel="noopener noreferrer"
              className="text-blue-600 hover:underline mt-2 block"
            >
              /r/{restaurant.slug}
            </a>
          </div>
        </div>
      </div>
    </div>
  );
}